# Calculate Assignment Hours
# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041130 - started first version, based on Measurement - Earned Value Hours
# 041209 - work on data update logic
# 041222 - logic to assign effort hours to assignment days
# 050421 - when creating indices, ignore time period assignment records that don't have valid assignment parents;
#		show hint message if require tables not available
# 050601 - Brian - Test for existence of resources in "Resource" table, not "Report" table
# 080428 - Alex - better algorithm for allocating effort hours

# It uses the following fields:
#	Assignment
#	- EffortHours
#	- TaskID
#	- ResourceID
#	Task
#	- EffortHours
#	- Duration
#	- ProjectID
#	- CalculatedStartDate
#	- hES
#	- hEF

#	Calculates the following: 
#      AssignmentDay (should it be possible to manually enter this? I don't think so)
#		PlannedEffortHours

#	Then summarized the EffortHours hours by:
#	- ProjectWeek
#     - ResourceWeek
#     - ResourceDay
#     - TaskWeek
#     - TaskDay
#     - AssignmentWeek
#     - AssignmentDay

# It uses the following:
#	- Assignment
#		Spread
#			None - same as even
#			'manual'
#			'even'
#			'early'
#		PlannedEffortHours
#	- Task
#		EffortHours
#		CalculatedStartDate
#		CalculatedEndDate

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def UpdateSummaryHours(self):
    """ 
# Allocate hours to each assignment day
# Build index for each of the database summary tables.
# Calculate all required summary totals.
# Scan through database summary tables and change any values that have changed, add rows as needed.
    """
    # make sure all required tables exist
    for table in ['ProjectWeek', 'ProjectMonth',
                  'ResourceDay', 'ResourceWeek', 'ResourceMonth',
                  'TaskDay', 'TaskWeek', 'TaskMonth',
                  'AssignmentDay', 'AssignmentWeek', 'AssignmentMonth']:
        # make sure these tables are in the database
        Data.AddTable(table)

    # create short cuts to all of the tables used
    dr = Data.Database['Resource']
    dp = Data.Database['Project']
    dt = Data.Database['Task']
    da = Data.Database['Assignment']
    dpw = Data.Database['ProjectWeek']
    dpm = Data.Database['ProjectMonth']
    drd = Data.Database['ResourceDay']
    drw = Data.Database['ResourceWeek']
    drm = Data.Database['ResourceMonth']
    dtd = Data.Database['TaskDay']
    dtw = Data.Database['TaskWeek']
    dtm = Data.Database['TaskMonth']
    dad = Data.Database['AssignmentDay']
    daw = Data.Database['AssignmentWeek']
    dam = Data.Database['AssignmentMonth']

# was going to create an index of lists of resource per task, but decided to use
# 	the Data.FindIDs function instead
#    # create list index of Assignment/Day table
#    rid = self.ReportID
#    if rid and dr.has_key(rid):
#        pid = dr.get('ProjectID')
#    if not rid or not pid: return
#
#    liad = {}
#    for k, v in dad.iteritems():
#        p = v.get('ProjectID')
#        if p != pid: continue

    # use task and assignment, allocate hours into a temporary task/resource/date table
    # key is "(taskid, resourceid, date)"
    sad = {} # save effort per assignment day here
    ia = {} # build index of assignment table here
    for k, v in da.iteritems(): # each assignment
        # make sure the record is valid
        if v.get('zzStatus') == 'deleted': continue
        taskid = v.get('TaskID')
        resourceid = v.get('ResourceID')
        if not taskid or not dt.has_key(taskid) or dt[taskid].get('zzStatus') == 'deleted': continue
        if not resourceid or not dr.has_key(resourceid)or dr[resourceid].get('zzStatus') == 'deleted': continue

        ia[(taskid, resourceid)] = k  # only including active records in index -- okay?

        es, ef = dt[taskid].get('hES'), dt[taskid].get('hEF')
        if not es or not ef: continue
        duration = ef - es

        # find the effort hours to allocate
        hours = da[k].get('EffortHours') # if individual hours assigned use them
        if hours == None:  # if not individual hours use part or all of task hours
            totalhours = dt[taskid].get('EffortHours')
            if totalhours != None:
                reslistall = Data.FindIDs('Assignment', 'TaskID', taskid, None, None) # calculate # people
                reslist = [ x for x in reslistall if da[x].get('zzStatus') != 'deleted' ]
                hours = totalhours / len(reslist)  # divide hours equally by people
        if hours == None: hours = duration  # default effort hours to duration hours for each person
        if not hours > 0: continue  # no hours to allocate

        multiplier = float(hours)/duration
        # first day (may be partial)
        date = dt[taskid].get('CalculatedStartDate')
        if not date or not Data.DateConv.has_key(date): continue  # make sure we can look update
        dateindex = Data.DateConv[date]
        dh, cum, dow = Data.DateInfo[dateindex]
        if es < cum:  # should never happen
            if debug: print "es before start date", es, cum, firstday
            continue
        elif es > cum: # take care of partial days so loop won't have to
            if debug: print "assignment starts during day, dh, cum, es", dh, cum, es
            dh -= (es - cum)
            if dh < 0: 
                if debug: print "es after end of start date", es, cum, firstday
                continue # should never happen
            newhours = dh * multiplier
            if newhours > 0 and newhours < 1:  # should I allow fractional planned hours?
               newhours = 1
            else:
               newhours = int(round(newhours))
            if newhours > hours:  # if greater than hours remaining, use remainder
                newhours = hours
            if newhours > 0:
                hours -= newhours
                sad[(taskid, resourceid, date)] = newhours
                dateindex += 1

        maxdays = 100
        cnt = 0
        realhours = discretehours = 0
        while hours > 0:
            cnt += 1
            if cnt > maxdays: break  # prevent endless loop errors

            dh, cum, dow = Data.DateInfo[dateindex]
            newhours = dh * multiplier
            if 0 < newhours < 1:
                newhours = 1

            realhours += newhours
            newhours = int(realhours) - discretehours
            if realhours % 1: newhours += 1  # takes fractional hours earlier
##            newhours = int(round(realhours)) - discretehours
            discretehours += newhours
            
            if newhours > hours:
                newhours = hours
            if newhours > 0:
                hours -= newhours
                date = Data.DateIndex[dateindex]
                sad[(taskid, resourceid, date)] = newhours
            dateindex += 1

    if debug: print "sad", sad

    # create many indexes (used to look up prior total)
    def makeindex(table, k1, k2):
        indx = {}
        for k, v in table.iteritems():
            indx[(v.get(k1), v.get(k2))] = k
        return indx

    ipw = makeindex(dpw, 'ProjectID', 'Period')
    ipm = makeindex(dpm, 'ProjectID', 'Period')
    ird = makeindex(drd, 'ResourceID', 'Period')
    irw = makeindex(drw, 'ResourceID', 'Period')
    irm = makeindex(drm, 'ResourceID', 'Period')
    itd = makeindex(dtd, 'TaskID', 'Period')
    itw = makeindex(dtw, 'TaskID', 'Period')
    itm = makeindex(dtm, 'TaskID', 'Period')

    def makeindex2(table1, table2, k1, k2, k3, k4):
        indx = {}
        for k, v in table1.iteritems():
            id = v.get(k1)
            if id and table2.has_key(id):
                a = table2[id].get(k2)
                b = table2[id].get(k3)
                c = v.get(k4)
                indx[(a, b, c)] = k
        return indx

    iad = makeindex2(dad, da, 'AssignmentID', 'TaskID', 'ResourceID', 'Period')
    iaw = makeindex2(daw, da, 'AssignmentID', 'TaskID', 'ResourceID', 'Period')
    iam = makeindex2(dam, da, 'AssignmentID', 'TaskID', 'ResourceID', 'Period')

    # create summaries by:
    # ProjectWeek
    # ResourceWeek
    # ResourceDay
    # TaskWeek
    # TaskDay
    # AssignmentWeek
    # AssignmentDay

    spw = {}; spm = {}
    srw = {}; srd = {}; srm = {};
    stw = {}; std = {}; stm = {}
    saw = {}; sam = {}
    for k, v in sad.iteritems():
        tid, rid, d = k
        aid = ia[(tid, rid)]

        pid = dt[tid].get('ProjectID')
        if not pid or not dp.has_key(pid): continue  # check for deleted record??

        di = Data.DateConv[d]
        w = Data.DateIndex[di - Data.DateInfo[di][2]]  # convert to beginning of week (date index) minus (day of week)
        mi = Data.GetPeriodStart("Month", di, 0)
        m = Data.DateToString(mi)
        hours = v

        if debug: print "t, r, p, d, w, h", tid, rid, pid, d, w, m, hours

        def dosum(stable, key):
            if stable.has_key(key):
                stable[key] += hours
            else:
                stable[key] = hours

        if hours:
            dosum(spw, (pid, w))
            dosum(spm, (pid, m))
            dosum(srd, (rid, d))
            dosum(srw, (rid, w))
            dosum(srm, (rid, m))
            dosum(std, (tid, d))
            dosum(stw, (tid, w))
            dosum(stm, (tid, m))
            dosum(saw, (tid, rid, w))
            dosum(sam, (tid, rid, m))

    # routines to update database from summaries

    def updatekey1week(stable, dtable, index, tablename, keyname):
        for k, v in stable.iteritems():
            key1, w = k
            hours = v
            id = index.get(k)
            if dtable.has_key(id):  # old total exists
                oldhours = dtable[id].get('EffortHours')
                if hours != oldhours:
                    change = { 'Table': tablename, 'ID': id, 'EffortHours': hours }
                    Data.Update(change)
                del index[k]  # remove old index; will process all remaining

            else:  # add new record
                change = { 'Table': tablename,
                               keyname: key1, 'Period': w, 'EffortHours': hours }
                Data.Update(change)

        for k in index.keys():
            id = index.get(k)
            oldhours = dtable[id].get('EffortHours')
            if oldhours:
                change = { 'Table': tablename, 'ID': id, 'EffortHours': None }
                Data.Update(change)

    def updatekey2week(stable, dtable, index1, index2, tablename, keyname):
        for k, v in stable.iteritems():
            key1, key2, w = k
            hours = v
            id = index1.get(k)
            if dtable.has_key(id):  # old total exists
                oldhours = dtable[id].get('EffortHours')
                if hours != oldhours:
                    change = { 'Table': tablename, 'ID': id,
                               'EffortHours': hours }
                    Data.Update(change)
                del index1[k]  # remove old index; will process all remaining

            else:  # add new record
                keyid = index2.get((key1, key2))
                change = { 'Table': tablename,
                               keyname: keyid, 'Period': w,
                               'EffortHours': hours }
                Data.Update(change)

        for k in index1.keys():
            id = index1.get(k)
            oldhours = dtable[id].get('EffortHours')
            if oldhours:
                change = { 'Table': tablename, 'ID': id,
                               'EffortHours': None }
                Data.Update(change)

    updatekey1week(spw, dpw, ipw, 'ProjectWeek', 'ProjectID')
    updatekey1week(spm, dpm, ipm, 'ProjectMonth', 'ProjectID')

    updatekey1week(srd, drd, ird, 'ResourceDay', 'ResourceID')
    updatekey1week(srw, drw, irw, 'ResourceWeek', 'ResourceID')
    updatekey1week(srm, drm, irm, 'ResourceMonth', 'ResourceID')

    updatekey1week(std, dtd, itd, 'TaskDay', 'TaskID')
    updatekey1week(stw, dtw, itw, 'TaskWeek', 'TaskID')
    updatekey1week(stm, dtm, itm, 'TaskMonth', 'TaskID')

    updatekey2week(sad, dad, iad, ia, 'AssignmentDay', 'AssignmentID')
    updatekey2week(saw, daw, iaw, ia, 'AssignmentWeek', 'AssignmentID')
    updatekey2week(sam, dam, iam, ia, 'AssignmentMonth', 'AssignmentID')

    Data.SetUndo('Update Planned Effort Summaries')

UpdateSummaryHours(self)
